/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.platform;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.Painter;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;

final class NimbusLookAndFeelSetup {
    NimbusLookAndFeelSetup() {
    }

    void setupLookAndFeel() {
        NimbusLookAndFeel laf = new NimbusLookAndFeel();
        try {
            UIManager.setLookAndFeel(laf);
            final Color background = new Color(240, 240, 240);
            laf.getDefaults().put("Panel.background", background);
            laf.getDefaults().put("MenuBar:Menu.contentMargins", new Insets(1, 5, 2, 10));
            laf.getDefaults().put("MenuBar:Menu[Selected].backgroundPainter", new MenuBackgroundColor());
            laf.getDefaults().put("Menu[Enabled+Selected].backgroundPainter", new MenuItemBackgroundColor());
            laf.getDefaults().put("Menu.contentMargins", new Insets(2, 7, 3, 13));
            laf.getDefaults().put("Menu[Enabled+Selected].textForeground", new Color(10, 10, 10));
            laf.getDefaults().put("MenuItem[MouseOver].backgroundPainter", new MenuItemBackgroundColor());
            laf.getDefaults().put("MenuItem.contentMargins", new Insets(2, 7, 3, 13));
            laf.getDefaults().put("MenuItem.textIconGap", (Object)6);
            laf.getDefaults().put("MenuItem[MouseOver].textForeground", new Color(10, 10, 10));
            laf.getDefaults().put("MenuItem:MenuItemAccelerator[MouseOver].textForeground", new Color(10, 10, 10));
            laf.getDefaults().put("List[Selected].textBackground", new Color(190, 220, 230));
            laf.getDefaults().put("List[Selected].textForeground", new Color(30, 30, 30));
            laf.getDefaults().put("Viewport.background", Color.white);
            laf.getDefaults().put("Table.alternateRowColor", Color.white);
            laf.getDefaults().put("FileChooser.background", background);
            laf.getDefaults().put("FileChooser[Enabled].backgroundPainter", new Painter<JFileChooser>(){

                @Override
                public void paint(Graphics2D g, JFileChooser object, int width, int height) {
                    g.setColor(background);
                    g.draw(object.getBounds());
                }
            });
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MenuItemBackgroundColor
    implements Painter<JComponent> {
        private static final Color insideRight = new Color(195, 225, 235);
        private static final Color border = new Color(100, 140, 150);

        private MenuItemBackgroundColor() {
        }

        @Override
        public void paint(Graphics2D g, JComponent c, int w, int h) {
            g.setColor(insideRight);
            g.fillRect(0, 0, w - 1, h - 1);
            g.setColor(border);
            g.drawRect(0, 0, w - 1, h - 1);
        }
    }

    private class MenuBackgroundColor
    implements Painter<JMenu> {
        private final Color color = new Color(160, 160, 160);

        private MenuBackgroundColor() {
        }

        @Override
        public void paint(Graphics2D g, JMenu c, int w, int h) {
            g.setColor(this.color);
            g.fillRect(0, 0, w, h);
        }
    }
}

